package elaprendiz.estructuras.funciones;

import elaprendiz.graficos.funciones.Funcion;

import java.awt.Point;

import java.util.Observer;
import java.util.Observable;

import elaprendiz.graficos.imagenes.ImageFrame;
import elaprendiz.graficos.imagenes.ObjetoImagen;

import elaprendiz.estructuras.nodos.Nodo;
import elaprendiz.estructuras.nodos.ArbolNodo;
import elaprendiz.estructuras.EstructuraLienzo;
import elaprendiz.estructuras.LienzoBinario;

public class MoverSubArbol extends Funcion {

  boolean izquierdaSuperior  = false;
  boolean DerechaSuperior = false;
  boolean izquierdaInferior  = false;
  boolean derechaInferior = false;

  ArbolNodo moverNodo = null;

  int limiteX;
  int limiteY;

  int moverX;
  int moverY;

  int movimientoTotalX = 0;
  int movimientoTotalY = 0;

  public MoverSubArbol(Point point, ArbolNodo node) {
    moverNodo = node;

    Point testPoint = node.origin();

    int xCurr = testPoint.x;
    int yCurr = testPoint.y;

    limiteX = (int) Math.abs((double) (point.x - xCurr));
    limiteY = (int) Math.abs((double) (point.y - yCurr));

    moverX = (int) Math.ceil((double) (limiteX / 10));
    moverY = (int) Math.ceil((double) (limiteY / 10));

    if ( (xCurr > point.x) && (yCurr > point.y))
      derechaInferior = true;
    else if (xCurr > point.x)
      DerechaSuperior = true;
    else if ( (xCurr < point.x) && (yCurr > point.y))
      izquierdaInferior  = true;
    else
      izquierdaSuperior  = true;
  }

  public void performFuncion() {
    if ( (movimientoTotalX == limiteX) && (movimientoTotalY == limiteY)) {

      ////////////////////////////////////////
      // Notify any observers that the func-
      // tion is terminado.

      setChanged();
      notifyObservers();

      terminado = true;

    }

    else {

      if (derechaInferior)
	moverNodo.translate(-moverX, -moverY);
      else if (DerechaSuperior)
	moverNodo.translate(-moverX, moverY);
      else if (izquierdaInferior)
	moverNodo.translate(moverX, -moverY);
      else
	moverNodo.translate(moverX, moverY);

      movimientoTotalX += moverX;
      movimientoTotalY += moverY;

      moverX = ( (limiteX - movimientoTotalX) < moverX) ? limiteX - movimientoTotalX: moverX;
      moverY = ( (limiteY - movimientoTotalY) < moverY) ? limiteY - movimientoTotalY: moverY;
    }
  }
}
